<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            افزودن مشتری جدید
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    @if ($errors->any())
                        <div class="mb-4 p-4 bg-red-100 text-red-700 border border-red-400 rounded">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('agent.customers.store') }}" method="POST">
                        @csrf
                        {{-- ردیف اول: نام و نام خانوادگی --}}
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <x-input-label for="name" value="نام*" />
                                <x-text-input id="name" name="name" type="text" class="mt-1 block w-full" :value="old('name')" required />
                            </div>
                            <div>
                                <x-input-label for="family_name" value="نام خانوادگی*" />
                                <x-text-input id="family_name" name="family_name" type="text" class="mt-1 block w-full" :value="old('family_name')" required />
                            </div>
                        </div>

                        {{-- ردیف دوم: کد ملی --}}
                        <div class="mb-6">
                            <x-input-label for="national_id" value="کد ملی*" />
                            <x-text-input id="national_id" name="national_id" type="text" class="mt-1 block w-full" :value="old('national_id')" />
                        </div>

                        {{-- ردیف سوم: استان و شهر --}}
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <x-input-label for="province" value="استان*" />
                                {{-- شما باید لیست استان‌ها را در اینجا قرار دهید --}}
                                <x-text-input id="province" name="province" type="text" class="mt-1 block w-full" :value="old('province')" />
                            </div>
                            <div>
                                <x-input-label for="city" value="شهر*" />
                                {{-- لیست شهرها باید بر اساس استان لود شود --}}
                                <x-text-input id="city" name="city" type="text" class="mt-1 block w-full" :value="old('city')" />
                            </div>
                        </div>

                        {{-- ردیف چهارم: آدرس --}}
                        <div class="mb-6">
                            <x-input-label for="address" value="آدرس محل اقامت*" />
                            <textarea id="address" name="address" rows="3" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full">{{ old('address') }}</textarea>
                        </div>
                        
                        {{-- ردیف پنجم: کد پستی --}}
                        <div class="mb-6">
                            <x-input-label for="postal_code" value="کدپستی*" />
                            <x-text-input id="postal_code" name="postal_code" type="text" class="mt-1 block w-full" :value="old('postal_code')" />
                        </div>

                        {{-- ردیف ششم: تلفن ثابت و همراه --}}
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <x-input-label for="phone" value="تلفن ثابت*" />
                                <x-text-input id="phone" name="phone" type="text" class="mt-1 block w-full" :value="old('phone')" />
                            </div>
                            <div>
                                <x-input-label for="mobile" value="تلفن همراه*" />
                                <x-text-input id="mobile" name="mobile" type="text" class="mt-1 block w-full" :value="old('mobile')" />
                            </div>
                        </div>

                        {{-- ردیف هفتم: تاریخ تولد --}}
                        <div>
                            <label class="block font-medium text-sm text-gray-700">تاریخ تولد*</label>
                            <div class="grid grid-cols-3 gap-4 mt-1">
                                <div>
                                    <x-input-label for="birth_date_day" value="روز" />
                                    <x-text-input id="birth_date_day" name="birth_date_day" type="text" class="block w-full" :value="old('birth_date_day')" placeholder="مثلا: 05" />
                                </div>
                                <div>
                                    <x-input-label for="birth_date_month" value="ماه" />
                                    <x-text-input id="birth_date_month" name="birth_date_month" type="text" class="block w-full" :value="old('birth_date_month')" placeholder="مثلا: 11" />
                                </div>
                                <div>
                                    <x-input-label for="birth_date_year" value="سال" />
                                    <x-text-input id="birth_date_year" name="birth_date_year" type="text" class="block w-full" :value="old('birth_date_year')" placeholder="مثلا: 1370" />
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-6">
                            <x-primary-button>
                                ایجاد کاربر (ذخیره مشتری)
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>