<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            ویرایش مشتری: {{ $customer->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    
                    {{-- ✅ فرم فقط فیلد description را ارسال می‌کند --}}
                    <form action="{{ route('agent.customers.update', $customer->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        {{-- پیام راهنما --}}
                        <div class="mb-4 p-4 bg-blue-50 text-blue-700 border border-blue-200 rounded">
                            توجه: اطلاعات هویتی مشتری (نام، کدملی، موبایل و...) پس از ثبت قابل تغییر نیست. شما فقط می‌توانید بخش توضیحات را ویرایش کنید.
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            {{-- ✅ readonly اضافه شد --}}
                            <div>
                                <x-input-label for="name" value="نام" />
                                <x-text-input id="name" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->first_name" readonly />
                            </div>
                            <div>
                                <x-input-label for="family_name" value="نام خانوادگی" />
                                <x-text-input id="family_name" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->family_name" readonly />
                            </div>
                            <div>
                                <x-input-label for="national_id" value="کد ملی" />
                                <x-text-input id="national_id" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->national_id" readonly />
                            </div>
                            <div>
                                <x-input-label for="mobile" value="موبایل" />
                                <x-text-input id="mobile" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->mobile" readonly />
                            </div>
                            <div>
                                <x-input-label for="phone" value="تلفن ثابت" />
                                <x-text-input id="phone" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->phone" readonly />
                            </div>
                            <div>
                                <x-input-label for="postal_code" value="کد پستی" />
                                <x-text-input id="postal_code" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->postal_code" readonly />
                            </div>
                            <div>
                                <x-input-label for="province" value="استان" />
                                <x-text-input id="province" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->province" readonly />
                            </div>
                            <div>
                                <x-input-label for="city" value="شهر" />
                                <x-text-input id="city" type="text" class="mt-1 block w-full bg-gray-100" :value="$customer->city" readonly />
                            </div>

                            {{-- ✅ فیلد آدرس (فقط خواندنی) --}}
                            <div class="md:col-span-2">
                                <x-input-label for="address" value="آدرس" />
                                <textarea id="address" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm bg-gray-100" rows="3" readonly>{{ $customer->address }}</textarea>
                            </div>

                            {{-- ✅✅✅ فیلد توضیحات (قابل ویرایش) ✅✅✅ --}}
                            <div class="md:col-span-2">
                                <x-input-label for="description" value="توضیحات نماینده (قابل ویرایش)" />
                                <textarea id="description" name="description" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" rows="3">{{ old('description', $customer->description) }}</textarea>
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button>
                                ذخیره توضیحات
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>