<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            لیست فاکتورهای من
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            {{-- بخش فیلترها --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <form method="GET" action="{{ route('agent.invoices.index') }}" class="p-4 grid grid-cols-1 md:grid-cols-3 gap-4">
                    <x-text-input type="text" 
                                  name="search" 
                                  placeholder="جستجو (شماره فاکتور، نام مشتری...)" 
                                  value="{{ request('search') }}" 
                                  class="w-full md:col-span-2" />
                    
                    {{-- ✅ START: فیلتر وضعیت اصلاح شد --}}
                    <select name="status" class="border-gray-300 rounded-md shadow-sm w-full" onchange="this.form.submit()">
                        <option value="all" @selected(request('status') == 'all')>همه وضعیت‌ها</option>
                        <option value="pending" @selected(request('status') == 'pending')>در انتظار پرداخت</option>
                        <option value="processing" @selected(request('status') == 'processing')>در حال انجام</option>
                        <option value="ready_to_ship" @selected(request('status') == 'ready_to_ship')>آماده برای ارسال</option>
                        <option value="shipped" @selected(request('status') == 'shipped')>ارسال شده</option>
                        <option value="delivered" @selected(request('status') == 'delivered')>تحویل داده شده</option>
                        <option value="returned" @selected(request('status') == 'returned')>مرجوع شده</option>
                        <option value="rejected" @selected(request('status') == 'rejected')>لغو شده</option>
                    </select>
                    {{-- ✅ END: فیلتر وضعیت اصلاح شد --}}
                </form>
            </div>

            {{-- نمایش کارتی فاکتورها --}}
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @forelse($invoices as $invoice)
                    <div class="bg-white overflow-hidden shadow-lg rounded-lg flex flex-col justify-between">
                        {{-- هدر کارت --}}
                        <div class="p-4 flex justify-between items-center border-b">
                            <span class="font-bold text-gray-800">#{{ $invoice->id }}</span>
                            @php
                                // ✅ START: رنگ‌بندی وضعیت اصلاح شد
                                $statusClasses = match($invoice->status) {
                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                    'processing' => 'bg-blue-100 text-blue-800',
                                    'ready_to_ship' => 'bg-cyan-100 text-cyan-800', // جدید
                                    'shipped' => 'bg-indigo-100 text-indigo-800',
                                    'delivered' => 'bg-green-100 text-green-800',
                                    'returned' => 'bg-orange-100 text-orange-800', // جدید
                                    'rejected' => 'bg-red-100 text-red-800',
                                    default => 'bg-gray-100 text-gray-800',
                                };
                                // ✅ END: رنگ‌بندی وضعیت اصلاح شد
                            @endphp
                            <span class="text-xs font-semibold px-3 py-1 rounded-full {{ $statusClasses }}">
                                {{-- (مطمئن شوید این ترجمه‌ها را در fa.json دارید) --}}
                                {{ __($invoice->status) }}
                            </span>
                        </div>

                        {{-- بدنه کارت (بدون تغییر) --}}
                        <div class="p-4 space-y-3 text-sm">
                            <p class="flex justify-between"><span class="text-gray-500">مشتری:</span><span class="font-medium">{{ $invoice->customer->name }}</span></p>
                            <p class="flex justify-between"><span class="text-gray-500">تعداد اقلام:</span><span class="font-medium">{{ $invoice->products_count }} کالا</span></p>
                            <p class="flex justify-between"><span class="text-gray-500">طرح:</span><span class="font-medium">{{ $invoice->planOption->plan->name }} ({{ $invoice->planOption->months }} ماهه)</span></p>
                            <p class="flex justify-between"><span class="text-gray-500">تاریخ:</span><span class="font-medium">{{ verta($invoice->created_at)->format('Y/m/d') }}</span></p>
                            <p class="flex justify-between text-base font-bold border-t pt-3 mt-3">
                                <span>مبلغ (ریال):</span>
                                <span>{{ number_format($invoice->final_price) }}</span>
                            </p>
                        </div>

                        {{-- دکمه‌ها (بدون تغییر) --}}
                        <div class="p-4 bg-gray-50 grid grid-cols-2 gap-3">
                            @if($invoice->status === 'pending')
                                <a href="{{ route('payment.start', $invoice->id) }}" class="block w-full text-center px-4 py-2 bg-green-600 border rounded-md font-semibold text-xs text-white uppercase hover:bg-green-500">
                                    پرداخت
                                </a>
                            @elseif($invoice->status === 'rejected')
                                <span class="block w-full text-center px-4 py-2 bg-red-500 border rounded-md font-semibold text-xs text-white uppercase cursor-not-allowed">
                                    لغو شده
                                </span>
                            @else
                                <span class="block w-full text-center px-4 py-2 bg-gray-400 border rounded-md font-semibold text-xs text-white uppercase cursor-not-allowed">
                                    در حال پیگیری
                                </span>
                            @endif

                            <a href="{{ route('agent.invoices.print', $invoice->id) }}" target="_blank" 
                               class="block w-full text-center px-4 py-2 bg-white border border-gray-300 rounded-md font-semibold text-xs text-gray-700 uppercase hover:bg-gray-50">
                                پیش فاکتور 
                            </a>
                        </div>
                    </div>
                @empty
                    <p class="col-span-3 text-center text-gray-500 py-10">
                        هیچ فاکتوری یافت نشد.
                    </p>
                @endforelse
            </div>

            <div class="mt-6">
                {{ $invoices->links() }}
            </div>
        </div>
    </div>
</x-app-layout>