<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            قدم دوم: انتخاب گزینه برای طرح "{{ $plan->name }}"
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @forelse($plan->options as $option)
                            {{-- با کلیک روی این گزینه، سبد خرید در سشن ساخته می‌شود --}}
                            <a href="{{ route('agent.cart.start', $option->id) }}" class="block p-6 bg-blue-50 border border-blue-200 rounded-lg shadow hover:bg-blue-100">
                                <h5 class="mb-2 text-2xl font-bold tracking-tight text-gray-900">{{ $option->months }} ماهه</h5>
                                <p class="font-normal text-gray-700">ضریب: {{ $option->coefficient }}٪</p>
                            </a>
                        @empty
                            <p>هیچ گزینه‌ای (مانند ۶ ماهه، ۱۲ ماهه) برای این طرح ثبت نشده است.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>