<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>پیش فاکتور شماره {{ $invoice->id }}</title>
    
    <style>
        body {
            /* ✅ مهم: استفاده از فونت dejavu sans (فونت داخلی dompdf) */
            font-family: 'Vazirmatn', sans-serif;
            direction: rtl;
            text-align: right;
            font-size: 11px;
            background-color: #fff;
            color: #333;
            line-height: 1.6;
        }
        .invoice-box {
            width: 95%;
            margin: 20px auto;
            padding: 25px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        /* (استایل‌های هدر شبیه به عکس نمونه) */
        .header-table td {
            padding: 5px 0;
            vertical-align: top;
        }
        .header-table .logo {
            max-width: 120px;
            max-height: 80px;
        }
        .header-table .company-details {
            text-align: left;
            font-size: 12px;
        }
        .header-table .invoice-title {
            font-size: 20px;
            font-weight: bold; /* 'bold' برای dejavu */
            text-align: center;
            padding: 10px 0;
        }

        /* (استایل‌های اطلاعات مشتری و فروشنده) */
        .info-table {
            margin-top: 20px;
            border: 1px solid #ddd;
        }
        .info-table th {
            background-color: #f9f9f9;
            text-align: right;
            padding: 8px 10px;
            font-size: 13px;
            font-weight: bold;
            border-bottom: 1px solid #ddd;
        }
        .info-table td {
            padding: 10px;
            vertical-align: top;
            line-height: 1.8;
        }

        /* (استایل‌های جدول محصولات) */
        .items-table {
            margin-top: 25px;
            border: 1px solid #ddd;
        }
        .items-table thead th {
            background-color: #f2f2f2;
            font-weight: bold;
            font-size: 11px;
            text-align: right;
            padding: 10px 8px;
            border-bottom: 2px solid #ccc;
        }
        .items-table tbody tr:nth-child(even) {
            background-color: #fcfcfc;
        }
        .items-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #eee;
        }

        /* (استایل‌های جمع کل) */
        .summary-table {
            margin-top: 20px;
            width: 50%;
            float: left;
            border: 1px solid #eee;
        }
        .summary-table td {
            padding: 8px 12px;
            border-bottom: 1px solid #eee;
        }
        .summary-table .total {
            font-weight: bold;
            font-size: 13px;
            background-color: #f5f5f5;
        }

        .footer-notes {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ccc;
            font-size: 10px;
            color: #777;
            clear: both;
        }
        
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .text-bold { font-weight: bold; }
    </style>
    </head>
<body>
    <div class="invoice-box">
        
        {{-- هدر: لوگو و اطلاعات شرکت --}}
        <table class="header-table">
            <tr>
                <td style="width: 25%;">
                    @if(!empty($settings['company_logo']))
                        <img src="{{ public_path('storage/' . $settings['company_logo']) }}" class="logo">
                    @else
                        <h2 style="margin: 0;">{{ $settings['company_name'] ?? 'نام شرکت' }}</h2>
                    @endif
                </td>
                <td style="width: 45%;" class="invoice-title">
                    پیش فاکتور
                </td>
                <td style="width: 30%;" class="company-details">
                    شماره: <span class="text-bold">#{{ $invoice->id }}</span><br>
                    تاریخ: {{ verta($invoice->created_at)->format('Y/m/d') }}<br>
                    نماینده: {{ $invoice->user->name ?? '-' }}
                </td>
            </tr>
        </table>
        
        {{-- اطلاعات فروشنده و خریدار (شبیه به نمونه) --}}
        <table class="info-table">
            <thead>
                <tr>
                    <th style="width: 50%;">اطلاعات فروشنده</th>
                    <th style="width: 50%;">اطلاعات مشتری</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <strong class="text-bold">{{ $settings['company_name'] ?? 'نام شرکت' }}</strong><br>
                        آدرس: {{ $settings['company_address'] ?? 'آدرس' }}<br>
                        تلفن: {{ $settings['company_phone'] ?? 'تلفن' }}
                    </td>
                    <td>
                        <strong class="text-bold">{{ $invoice->customer->name }}</strong><br>
                        کد ملی: {{ $invoice->customer->national_id ?? '-' }}<br>
                        موبایل: {{ $invoice->customer->mobile ?? '-' }}<br>
                        آدرس: {{ $invoice->customer->address ?? '-' }}
                    </td>
                </tr>
            </tbody>
        </table>

        {{-- جدول محصولات (سبد خرید) - شبیه به عکس نمونه --}}
        <h3 style="margin-top: 25px; margin-bottom: 10px; font-size: 16px;" class="text-bold">شرح کالا</h3>
        <table class="items-table">
            <thead>
                <tr>
                    <th style="width: 5%;">ردیف</th>
                    <th style="width: 40%;">عنوان</th>
                    <th class="text-center" style="width: 10%;">تعداد</th>
                    <th class="text-left" style="width: 20%;">قیمت واحد پایه (ریال)</th>
                    <th class="text-left" style="width: 25%;">جمع (ریال)</th>
                </tr>
            </thead>
            <tbody>
                @php $totalBase = 0; @endphp
                @foreach($invoice->products as $index => $product)
                    @php $itemTotalBase = $product->pivot->price * $product->pivot->quantity; @endphp
                    <tr>
                        <td class="text-center">{{ $index + 1 }}</td>
                        <td>
                            <span class="text-bold">{{ $product->name }}</span>
                        </td>
                        <td class="text-center">{{ $product->pivot->quantity }}</td>
                        <td class="text-left">{{ number_format($product->pivot->price) }}</td>
                        <td class="text-left text-bold">{{ number_format($itemTotalBase) }}</td>
                    </tr>
                    @php $totalBase += $itemTotalBase; @endphp
                @endforeach
            </tbody>
        </table>

        {{-- بخش جمع کل - شبیه به عکس نمونه --}}
        <table class="summary-table">
            <tr>
                <td>جمع کل پایه (ریال)</td>
                <td class="text-left text-bold">{{ number_format($totalBase) }}</td>
            </tr>
            <tr>
                <td>
                    کارمزد اقساط (طرح: {{ $invoice->planOption->plan->name }} / {{ $invoice->planOption->months }} ماهه)
                </td>
                <td class="text-left text-bold">{{ number_format($invoice->final_price - $totalBase) }}</td>
            </tr>
            <tr class="total">
                <td>جمع به ریال (مبلغ نهایی)</td>
                <td class="text-left">{{ number_format($invoice->final_price) }}</td>
            </tr>
        </table>

        <div class="footer-notes">
            <p class="text-bold">توضیحات:</p>
            <p>این پیش فاکتور صرفا جهت ارائه به بانک بوده و فاقد هرگونه ارزش دیگر است.</p>
        </div>

    </div>
</body>
</html>