<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            قدم دوم: انتخاب محصول برای طرح "{{ $plan->name }}"
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    
                    {{-- جدول نمایش محصولات (شبیه به عکس) --}}
                    <div class="overflow-x-auto border rounded-lg">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">ردیف</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">تصویر</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">عنوان</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">قیمت پایه (ریال)</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">عملیات (انتخاب طرح)</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($products as $product)
                                    <tr>
                                        <td class="px-6 py-4">{{ $loop->iteration }}</td>
                                        <td class="px-6 py-4">
                                            <img src="{{ $product->image_path ? asset('storage/' . $product->image_path) : 'https://via.placeholder.com/80' }}" 
                                                 alt="{{ $product->name }}" 
                                                 class="w-16 h-16 object-cover rounded">
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="font-medium">{{ $product->name }}</div>
                                            <div class="text-sm text-gray-500">{{ $product->code }}</div>
                                        </td>
                                        <td class="px-6 py-4 font-bold">
                                            {{-- --}}
                                            @if($product->discount_price && $product->discount_price > 0)
                                                <span class="text-red-600">{{ number_format($product->active_price) }}</span>
                                            @else
                                                <span>{{ number_format($product->active_price) }}</span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            {{-- نمایش گزینه‌های اقساط به جای "مشاهده" --}}
                                            <div class="space-y-2 flex flex-col items-start">
                                                @forelse($plan->options as $option)
                                                    <a href="{{ route('agent.invoices.create', ['product_id' => $product->id, 'plan_option_id' => $option->id]) }}" 
                                                       class="inline-flex items-center px-3 py-1 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-500">
                                                        انتخاب {{ $option->months }} ماهه
                                                    </a>
                                                @empty
                                                    <span class="text-red-500 text-xs">گزینه‌ای برای این طرح ثبت نشده</span>
                                                @endforelse
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-6">هیچ محصول فعالی برای این طرح یافت نشد.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</x-app-layout>