<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            قدم اول: انتخاب طرح اقساط
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @forelse($plans as $plan)
                            <a href="{{ route('agent.plans.options', $plan->id) }}" class="block p-6 bg-white border border-gray-200 rounded-lg shadow hover:bg-gray-100">
                                <h5 class="mb-2 text-2xl font-bold tracking-tight text-gray-900">{{ $plan->name }}</h5>
                                <p class="font-normal text-gray-700">نوع طرح: {{ __($plan->type) }}</p>
                            </a>
                        @empty
                            <p>هیچ طرح فعالی یافت نشد.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>