<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            @if(!empty($data))
                
                {{-- ... (بخش فیلتر نمایندگان - بدون تغییر) ... --}}
                <div class="mb-6 bg-white p-4 shadow-sm sm:rounded-lg" 
                     x-data="dashboardAgentFilter({
                        selectedAgent: '{{ request('agent_id', 'all') }}',
                        agents: {{ json_encode($data['agents_list'] ?? []) }},
                        urls: {
                            dashboard: '{{ route('dashboard') }}',
                            toggleStatusBase: '/admin/users'
                        },
                        csrf: '{{ csrf_token() }}'
                     })">
                    
                    <div class="flex items-center space-x-4 space-x-reverse">
                        <label for="agent_filter" class="font-medium text-gray-700">فیلتر گزارش بر اساس نماینده:</label>
                        <select id="agent_filter" x-model="selectedAgent" @change="changeAgent" class="border-gray-300 rounded-md shadow-sm w-1/3">
                            <option value="all">-- نمایش آمار کل --</option>
                            <template x-for="agent in agents" :key="agent.id">
                                <option :value="agent.id" x-text="agent.name + (agent.status === 'active' ? ' (فعال)' : ' (غیرفعال)')"></option>
                            </template>
                        </select>
                        <template x-if="selectedAgent !== 'all' && agents.find(a => a.id == selectedAgent)">
                            <button @click.prevent="toggleStatus(selectedAgent, agents.find(a => a.id == selectedAgent).name)"
                                    :class="{
                                        'bg-red-500 hover:bg-red-600': agents.find(a => a.id == selectedAgent)?.status === 'active',
                                        'bg-green-500 hover:bg-green-600': agents.find(a => a.id == selectedAgent)?.status === 'inactive'
                                    }"
                                    class="px-3 py-2 text-white text-xs rounded-md">
                                <span x-text="agents.find(a => a.id == selectedAgent)?.status === 'active' ? 'غیرفعال کردن' : 'فعال کردن'"></span>
                            </button>
                        </template>
                    </div>
                    @if(!empty($data['selected_agent']))
                        <div class="mt-2 text-sm text-gray-500">
                            * در حال مشاهده گزارش‌های مربوط به: <span class="font-bold">{{ $data['selected_agent']->name }}</span>
                        </div>
                    @endif
                </div>


                {{-- ✅ START: بخش آمار وضعیت‌های خاص (اصلاح شده) --}}
                <h3 class="text-xl font-bold text-gray-800 mb-4">آمار وضعیت‌های خاص</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-3 gap-6 mb-8">
                    {{-- در انتظار پرداخت (Pending) --}}
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-yellow-400">
                        <h4 class="text-gray-600 font-medium">در انتظار پرداخت</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2">{{ $data['stats']['pending']['count'] }} <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-yellow-600 mt-1">{{ number_format($data['stats']['pending']['amount']) }} <span class="text-xs">ریال</span></p>
                    </div>
                    {{-- در حال انجام (Processing) --}}
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-blue-400">
                        <h4 class="text-gray-600 font-medium">در حال انجام</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2">{{ $data['stats']['processing']['count'] }} <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-blue-600 mt-1">{{ number_format($data['stats']['processing']['amount']) }} <span class="text-xs">ریال</span></p>
                    </div>
                    {{-- آماده ارسال (Ready to Ship) - جدید --}}
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-cyan-400">
                        <h4 class="text-gray-600 font-medium">آماده برای ارسال</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2">{{ $data['stats']['ready_to_ship']['count'] }} <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-cyan-600 mt-1">{{ number_format($data['stats']['ready_to_ship']['amount']) }} <span class="text-xs">ریال</span></p>
                    </div>
                    {{-- ارسال شده (Shipped) --}}
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-indigo-400">
                        <h4 class="text-gray-600 font-medium">ارسال شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2">{{ $data['stats']['shipped']['count'] }} <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-indigo-600 mt-1">{{ number_format($data['stats']['shipped']['amount']) }} <span class="text-xs">ریال</span></p>
                    </div>
                    {{-- تحویل شده (Delivered) --}}
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-green-400">
                        <h4 class="text-gray-600 font-medium">تحویل داده شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2">{{ $data['stats']['delivered']['count'] }} <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-green-600 mt-1">{{ number_format($data['stats']['delivered']['amount']) }} <span class="text-xs">ریال</span></p>
                    </div>
                    {{-- مرجوع (Returned) - جدید --}}
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-orange-400">
                        <h4 class="text-gray-600 font-medium">مرجوع شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2">{{ $data['stats']['returned']['count'] }} <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-orange-600 mt-1">{{ number_format($data['stats']['returned']['amount']) }} <span class="text-xs">ریال</span></p>
                    </div>
                    {{-- لغو شده (Rejected) - به انتهای لیست منتقل شد --}}
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-red-400">
                        <h4 class="text-gray-600 font-medium">لغو شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2">{{ $data['stats']['rejected']['count'] }} <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-red-600 mt-1">{{ number_format($data['stats']['rejected']['amount']) }} <span class="text-xs">ریال</span></p>
                    </div>
                </div>
                {{-- ✅ END: بخش آمار --}}

                {{-- بخش نمودارهای عمومی --}}
                <h3 class="text-xl font-bold text-gray-800 mb-4">نمودارهای عمومی</h3>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                    <div class="bg-white p-6 rounded-lg shadow-lg">
                        <h4 class="text-gray-800 font-bold mb-4">فروش ۳ ماه گذشته (شمسی)</h4>
                        <canvas id="monthSalesChart"></canvas>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-lg">
                        <h4 class="text-gray-800 font-bold mb-4">وضعیت سفارش‌ها (پرداخت شده)</h4>
                        <canvas id="statusPieChart" class="max-h-80 mx-auto"></canvas>
                    </div>
                </div>

                {{-- ... (بقیه کدهای داشبورد: نمودارهای نماینده و رتبه‌بندی - بدون تغییر) ... --}}
                @if(isset($data['products_chart_labels']))
                    <h3 class="text-xl font-bold text-gray-800 mb-4">گزارش‌های نماینده: {{ $data['selected_agent']->name }}</h3>
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                        <div class="bg-white p-6 rounded-lg shadow-lg">
                            <h4 class="text-gray-800 font-bold mb-4">۱۰ محصول پرفروش (تعداد)</h4>
                            <canvas id="productsChart"></canvas>
                        </div>
                        <div class="bg-white p-6 rounded-lg shadow-lg">
                            <h4 class="text-gray-800 font-bold mb-4">فروش بر اساس دسته‌بندی (تعداد)</h4>
                            <canvas id="categoriesChart" class="max-h-80 mx-auto"></canvas>
                        </div>
                    </div>
                @endif
                @if(auth()->user()->role === 'super_admin' && !empty($data['agent_rankings']))
                    <h3 class="text-xl font-bold text-gray-800 mb-4">رتبه‌بندی نمایندگان (۵ برتر)</h3>
                    <div class="bg-white overflow-hidden shadow-lg sm:rounded-lg p-6">
                        <ul class="space-y-3">
                            @forelse($data['agent_rankings'] as $agent)
                                <li class="flex justify-between items-center text-sm border-b pb-2">
                                    <span class="text-gray-700">{{ $agent->user->name ?? 'نماینده حذف شده' }}</span>
                                    <span class="font-semibold text-green-600">{{ number_format($agent->total_sales) }} ریال</span>
                                </li>
                            @empty
                                <li class="text-gray-500">اطلاعاتی برای نمایش وجود ندارد.</li>
                            @endforelse
                        </ul>
                    </div>
                @endif

            @else
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        به پنل خود خوش آمدید!
                    </div>
                </div>
            @endif

        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    @if(!empty($data))
        <script>
            // ✅ START: نمودار فروش ماهانه (اصلاح شده)
            const monthCtx = document.getElementById('monthSalesChart');
            new Chart(monthCtx, {
                type: 'bar',
                data: {
                    labels: @json($data['month_chart_labels']),
                    datasets: [{
                        label: 'مبلغ فروش (ریال)',
                        data: @json($data['month_chart_data']),
                        // ✅ رنگ‌های درخواستی شما (قرمز، آبی، سبز)
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.5)', // قرمز (ماه اول)
                            'rgba(54, 162, 235, 0.5)', // آبی (ماه دوم)
                            'rgba(75, 192, 192, 0.5)', // سبز (ماه جاری)
                        ],
                        borderColor: [
                            'rgba(255, 99, 132, 1)',
                            'rgba(54, 162, 235, 1)',
                            'rgba(75, 192, 192, 1)',
                        ],
                        borderWidth: 1
                    }]
                },
                options: { 
                    scales: { y: { beginAtZero: true } },
                    plugins: {
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    let label = context.dataset.label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    if (context.parsed.y !== null) {
                                        label += new Intl.NumberFormat('fa-IR').format(context.parsed.y) + ' ریال';
                                    }
                                    return label;
                                }
                            }
                        }
                    }
                }
            });
            // ✅ END: نمودار فروش ماهانه

            // ✅ START: نمودار دایره‌ای (اصلاح شده)
            const pieCtx = document.getElementById('statusPieChart');
            new Chart(pieCtx, {
                type: 'pie',
                data: {
                    labels: @json($data['status_chart_labels']), // این لیبل‌ها از کنترلر می‌آیند
                    datasets: [{
                        label: 'تعداد سفارش‌ها',
                        data: @json($data['status_chart_data']),
                        backgroundColor: [
                            'rgba(54, 162, 235, 0.5)',  // processing (آبی)
                            'rgba(153, 102, 255, 0.5)', // ready_to_ship (بنفش)
                            'rgba(75, 192, 192, 0.5)',  // shipped (سبزآبی)
                            'rgba(255, 206, 86, 0.5)', // delivered (زرد)
                            'rgba(255, 159, 64, 0.5)', // returned (نارنجی)
                        ],
                    }]
                }
            });
            // ✅ END: نمودار دایره‌ای

            // ... (اسکریپت‌های نمودارهای نماینده و Alpine.js فیلتر - بدون تغییر) ...
            @if(isset($data['products_chart_labels']))
                const productsCtx = document.getElementById('productsChart');
                new Chart(productsCtx, {
                    type: 'bar',
                    data: {
                        labels: @json($data['products_chart_labels']),
                        datasets: [{
                            label: 'تعداد فروش',
                            data: @json($data['products_chart_data']),
                            backgroundColor: 'rgba(255, 99, 132, 0.5)',
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 1
                        }]
                    },
                    options: { 
                        scales: { y: { beginAtZero: true } },
                        indexAxis: 'y', 
                    }
                });
                const categoriesCtx = document.getElementById('categoriesChart');
                new Chart(categoriesCtx, {
                    type: 'doughnut',
                    data: {
                        labels: @json($data['categories_chart_labels']),
                        datasets: [{
                            label: 'تعداد فروش',
                            data: @json($data['categories_chart_data']),
                            backgroundColor: [
                                'rgba(255, 159, 64, 0.5)',
                                'rgba(75, 192, 192, 0.5)',
                                'rgba(153, 102, 255, 0.5)',
                                'rgba(255, 206, 86, 0.5)',
                            ],
                        }]
                    }
                });
            @endif
            function dashboardAgentFilter(data) {
                return {
                    selectedAgent: data.selectedAgent,
                    agents: data.agents,
                    changeAgent() {
                        if (this.selectedAgent === 'all') {
                            window.location.href = data.urls.dashboard;
                        } else {
                            window.location.href = data.urls.dashboard + '?agent_id=' + this.selectedAgent;
                        }
                    },
                    toggleStatus(agentId, agentName) {
                        if (!confirm(`آیا از تغییر وضعیت نماینده "${agentName}" مطمئن هستید؟`)) return;
                        let agent = this.agents.find(a => a.id == agentId);
                        fetch(`${data.urls.toggleStatusBase}/${agentId}/toggle-status`, {
                            method: 'PATCH',
                            headers: {
                                'X-CSRF-TOKEN': data.csrf,
                                'Accept': 'application/json'
                            }
                        })
                        .then(res => res.json())
                        .then(resData => { 
                            if (resData.success) { 
                                alert(resData.message); 
                                if (agent) agent.status = resData.new_status; 
                            } else { 
                                alert(resData.error || 'خطایی رخ داد.'); 
                            } 
                        })
                        .catch(err => alert('خطای ارتباطی.')); 
                    } 
                };
            }
        </script>
    @endif
</x-app-layout>