<nav x-data="{ open: false }" class="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('dashboard') }}">
                        <x-application-logo class="block h-9 w-auto fill-current text-gray-800 dark:text-gray-200" />
                    </a>
                </div>

                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                        {{ __('Dashboard') }}
                    </x-nav-link>

                    {{-- لینک‌های مخصوص نماینده --}}
                    @if(auth()->user()->role === 'agent')
                        <x-nav-link :href="route('agent.plans.list')" :active="request()->routeIs('agent.plans.*') || request()->routeIs('agent.cart.*')">
                            ثبت پیش فاکتور جدید
                        </x-nav-link>
                        <x-nav-link :href="route('agent.invoices.index')" :active="request()->routeIs('agent.invoices.index')">
                            پیش فاکتورهای من
                        </x-nav-link>
                        <x-nav-link :href="route('agent.customers.index')" :active="request()->routeIs('agent.customers.*')">
                            مدیریت مشتریان
                        </x-nav-link>
                    
                    @elseif(auth()->user()->role !== 'regional_manager')
                        {{-- لینک محصولات برای مدیران (غیر-نماینده و غیر-مدیرمنطقه) --}}
                        <x-nav-link :href="route('admin.products.index')" :active="request()->routeIs('admin.products.*')">
                            {{ __('Products') }}
                        </x-nav-link>
                    @endif

                    {{-- لینک کاربران (فقط ادمین کل) --}}
                    @if(auth()->user()->role == 'super_admin')
                        <x-nav-link :href="route('admin.users.index')" :active="request()->routeIs('admin.users.*')">
                            {{ __('Users') }}
                        </x-nav-link>
                    @endif

                    {{-- لینک‌های مخصوص مدیر کل --}}
                    @if(auth()->user()->role == 'super_admin')
                        
                        <x-nav-link :href="route('admin.invoices.index')" :active="request()->routeIs('admin.invoices.*')">
                            تایید پیش فاکتورها
                        </x-nav-link>

                        <x-nav-link :href="route('admin.reports.index')" :active="request()->routeIs('admin.reports.*')">
                            گزارش‌ها
                        </x-nav-link>

                        <x-nav-link :href="route('admin.bundles.index')" :active="request()->routeIs('admin.bundles.*')">
                            مدیریت باندل‌ها
                        </x-nav-link>
                        <x-nav-link :href="route('admin.categories.index')" :active="request()->routeIs('admin.categories.*')">
                            دسته‌بندی‌ها
                        </x-nav-link>
                        <x-nav-link :href="route('admin.inventory.index')" :active="request()->routeIs('admin.inventory.index')">
                            مدیریت انبار
                        </x-nav-link>
                        <x-nav-link :href="route('admin.plans.index')" :active="request()->routeIs('admin.plans.*')">
                            {{ __('Plans') }}
                        </x-nav-link>
                        <x-nav-link :href="route('admin.settings.index')" :active="request()->routeIs('admin.settings.index')">
                            {{ __('Settings') }}
                        </x-nav-link>
                    @endif

                    {{-- لینک مخصوص مدیر منطقه --}}
                    @if(auth()->user()->role == 'regional_manager')
                        <x-nav-link :href="route('regional-manager.invoices.index')" :active="request()->routeIs('regional-manager.invoices.*')">
                            {{ __('Approve Invoices') }}
                        </x-nav-link>
                        <x-nav-link :href="route('regional-manager.users.index')" :active="request()->routeIs('regional-manager.users.index')">
                            مدیریت کاربران
                        </x-nav-link>
                        <x-nav-link :href="route('regional-manager.products.index')" :active="request()->routeIs('regional-manager.products.index')">
                            مشاهده محصولات
                        </x-nav-link>
                    @endif

                    {{-- لینک حسابدار --}}
                    @if(auth()->user()->role == 'accountant')
                        <x-nav-link :href="route('accountant.invoices.index')" :active="request()->routeIs('accountant.invoices.*')">
                            گزارش پیش فاکتورها
                        </x-nav-link>
                    @endif
                </div>
            </div>

            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none transition ease-in-out duration-150">
                            <div>{{ Auth::user()->name }}</div>

                            <div class="ms-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile.edit')">
                            {{ __('Profile') }}
                        </x-dropdown-link>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf

                            <x-dropdown-link :href="route('logout')"
                                    onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                {{ __('Dashboard') }}
            </x-responsive-nav-link>
            
            {{-- (لینک‌های موبایل نماینده) --}}
            @if(auth()->user()->role === 'agent')
                 <x-responsive-nav-link :href="route('agent.plans.list')" :active="request()->routeIs('agent.plans.*') || request()->routeIs('agent.cart.*')">
                    ثبت پیش فاکتور جدید
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('agent.invoices.index')" :active="request()->routeIs('agent.invoices.index')">
                    پیش فاکتورهای من
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('agent.customers.index')" :active="request()->routeIs('agent.customers.*')">
                    مدیریت مشتریان
                </x-responsive-nav-link>
            
            @elseif(auth()->user()->role !== 'regional_manager')
                <x-responsive-nav-link :href="route('admin.products.index')" :active="request()->routeIs('admin.products.*')">
                    {{ __('Products') }}
                </x-responsive-nav-link>
            @endif

            {{-- (لینک‌های موبایل ادمین کل) --}}
            @if(auth()->user()->role == 'super_admin')
                <x-responsive-nav-link :href="route('admin.users.index')" :active="request()->routeIs('admin.users.*')">
                    {{ __('Users') }}
                </x-responsive-nav-link>
                
                <x-responsive-nav-link :href="route('admin.invoices.index')" :active="request()->routeIs('admin.invoices.*')">
                    تایید پیش فاکتورها
                </x-responsive-nav-link>

                <x-responsive-nav-link :href="route('admin.reports.index')" :active="request()->routeIs('admin.reports.*')">
                    گزارش‌ها
                </x-responsive-nav-link>

                <x-responsive-nav-link :href="route('admin.bundles.index')" :active="request()->routeIs('admin.bundles.*')">
                    مدیریت باندل‌ها
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.categories.index')" :active="request()->routeIs('admin.categories.*')">
                    دسته‌بندی‌ها
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.inventory.index')" :active="request()->routeIs('admin.inventory.index')">
                    مدیریت انبار
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.plans.index')" :active="request()->routeIs('admin.plans.*')">
                    {{ __('Plans') }}
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.settings.index')" :active="request()->routeIs('admin.settings.index')">
                    {{ __('Settings') }}
                </x-responsive-nav-link>
            @endif

            {{-- (لینک موبایل مدیر منطقه) --}}
            @if(auth()->user()->role == 'regional_manager')
                <x-responsive-nav-link :href="route('regional-manager.invoices.index')" :active="request()->routeIs('regional-manager.invoices.*')">
                    {{ __('Approve Invoices') }}
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('regional-manager.users.index')" :active="request()->routeIs('regional-manager.users.index')">
                    مدیریت کاربران
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('regional-manager.products.index')" :active="request()->routeIs('regional-manager.products.index')">
                    مشاهده محصولات
                </x-responsive-nav-link>
            @endif

            {{-- (لینک موبایل حسابدار) --}}
            @if(auth()->user()->role == 'accountant')
                <x-responsive-nav-link :href="route('accountant.invoices.index')" :active="request()->routeIs('accountant.invoices.*')">
                    گزارش پیش فاکتورها
                </x-responsive-nav-link>
            @endif
        </div>

        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf

                    <x-responsive-nav-link :href="route('logout')"
                            onclick="event.preventDefault();
                                        this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
        </div>
</nav>