<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            تکمیل پرداخت پیش فاکتور شماره {{ $invoice->id }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 md:p-10 text-gray-900">

                    {{-- خلاصه فاکتور (بدون تغییر) --}}
                    <div class="border rounded-lg overflow-hidden mb-8">
                        {{-- (کد هدر، جدول محصولات و جمع کل فاکتور بدون تغییر) --}}
                        <div class="p-4 bg-gray-50 border-b"><h3 class="text-lg font-bold">خلاصه پیش فاکتور</h3></div>
                        <div class="p-6 space-y-3 border-b">
                            <p class="flex justify-between"><span class="text-gray-600">مشتری:</span><span class="font-medium">{{ $invoice->customer->name }}</span></p>
                            <p class="flex justify-between"><span class="text-gray-600">طرح:</span><span class="font-medium">{{ $invoice->planOption->plan->name }} ({{ $invoice->planOption->months }} ماهه)</span></p>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="min-w-full">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="py-2 px-4 text-right text-sm font-semibold text-gray-600">عنوان</th>
                                        <th class="py-2 px-4 text-center text-sm font-semibold text-gray-600">تعداد</th>
                                        <th class="py-2 px-4 text-left text-sm font-semibold text-gray-600">جمع (پایه - ریال)</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y">
                                    @php $totalBase = 0; @endphp
                                    @foreach($invoice->products as $product)
                                        @php $itemTotalBase = $product->pivot->price * $product->pivot->quantity; @endphp
                                        <tr class="text-sm">
                                            <td class="p-3">{{ $product->name }}</td>
                                            <td class="p-3 text-center">{{ $product->pivot->quantity }}</td>
                                            <td class="p-3 text-left font-medium">{{ number_format($itemTotalBase) }}</td>
                                        </tr>
                                        @php $totalBase += $itemTotalBase; @endphp
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="p-6 bg-gray-50 border-t space-y-3">
                             @php
                                $remainingAmountRial = $invoice->final_price - $invoice->paid_amount_cash;
                            @endphp
                            <p class="flex justify-between"><span>جمع کل پایه (ریال):</span> <span class="font-medium">{{ number_format($totalBase) }}</span></p>
                            <p class="flex justify-between"><span>کارمزد اقساط (ریال):</span> <span class="font-medium">{{ number_format($invoice->final_price - $totalBase) }}</span></p>
                            <hr>
                            <p class="flex justify-between text-lg font-bold"><span>مبلغ کل (ریال):</span> <span>{{ number_format($invoice->final_price) }}</span></p>
                            <p class="flex justify-between text-lg font-bold text-blue-600"><span>پرداخت نقدی (ریال):</span> <span>{{ number_format($invoice->paid_amount_cash) }}</span></p>
                            <div class="flex justify-between text-2xl font-bold text-green-700 bg-green-50 p-4 rounded-lg">
                                <span>مبلغ باقیمانده (ریال):</span>
                                <span>{{ number_format($remainingAmountRial) }}</span>
                            </div>
                        </div>
                    </div>

                    {{-- نمایش خطاهای اعتبارسنجی --}}
                    @if ($errors->any())
                        <div class="mb-4 p-4 bg-red-100 text-red-700 border border-red-400 rounded">
                            <strong>خطا! لطفاً موارد زیر را اصلاح کنید:</strong>
                            <ul class="list-disc list-inside mt-2">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{-- ✅✅✅ START: بخش پرداخت با منطق شرطی ✅✅✅ --}}
                    
                    @if($invoice->planOption->plan->type === 'check')
                        
                        {{-- ********* حالت طرح چکی ********* --}}
                        {{-- ✅ متغیر $cheque_documents اضافه شد تا فایل‌های موجود خوانده شوند --}}
                        @php
                            $cheque_documents = json_decode($invoice->cheque_document_paths, true);
                        @endphp
                        
                        {{-- ✅ x-data برای نمایش/مخفی کردن فرم آپلود اضافه شد --}}
                        <div class="border rounded-lg p-6" 
                             x-data="{ 
                                cheques: [{ id: 1 }],
                                reupload: {{ empty($cheque_documents) ? 'true' : 'false' }}, // اگر فایلی نبود، فرم را نشان بده
                                addCheque() {
                                    if (this.cheques.length < 16) {
                                        this.cheques.push({ id: Date.now() });
                                    } else {
                                        alert('حداکثر ۱۶ فایل مجاز است.');
                                    }
                                },
                                removeCheque(index) {
                                    if (this.cheques.length > 1) {
                                        this.cheques.splice(index, 1);
                                    }
                                }
                             }">
                            
                            {{-- فرم پرداخت نقدی به همراه آپلود چک --}}
                            <form action="{{ route('payment.cash.redirect', $invoice->id) }}" method="POST" enctype="multipart/form-data">
                                @csrf

                                <h3 class="text-lg font-bold mb-4 text-center">پرداخت نقدی (طرح چکی)</h3>
                                
                                {{-- ۱. مبلغ پرداخت نقدی (اختیاری شده در فاز قبل) --}}
                                <div class="mb-6">
                                    <x-input-label for="partial_amount" value="مبلغ پرداخت نقدی (اختیاری - به ریال)" />
                                    <p class="text-sm text-gray-600 mb-2">در صورت عدم پرداخت نقدی، این فیلد را خالی یا 0 بگذارید.</p>
                                    <x-text-input id="partial_amount" name="partial_amount" type="number" class="mt-1 block w-full" 
                                                  min="0" max="{{ $remainingAmountRial }}" 
                                                  :value="old('partial_amount', 0)" />
                                </div>
                                
                                <hr class="my-6">

                                {{-- ۲. آپلود ۱۶ فایل چک (اصلاح شده) --}}
                                
                                {{-- ✅ START: نمایش فایل‌های آپلود شده (برای رفرش) --}}
                                <div x-show="!reupload" x-transition>
                                    <h3 class="text-lg font-semibold mb-4">فایل‌های چک آپلود شده:</h3>
                                    <ul class="list-disc list-inside mt-2 space-y-2 p-4 bg-gray-50 rounded-lg">
                                        @if(!empty($cheque_documents))
                                            @foreach($cheque_documents as $index => $cheque)
                                                <li>
                                                    <a href="{{ asset('storage/' . $cheque) }}" target="_blank" class="text-indigo-600 hover:underline">
                                                        فایل چک {{ $index + 1 }}
                                                    </a>
                                                </li>
                                            @endforeach
                                        @endif
                                    </ul>
                                    <button type="button" @click="reupload = true" class="mt-4 text-sm text-blue-600 hover:text-blue-800">
                                        آپلود مجدد / تغییر فایل‌ها
                                    </button>
                                </div>
                                {{-- ✅ END: نمایش فایل‌های آپلود شده --}}
                                
                                {{-- ✅ START: فرم آپلود (در صورت نیاز) --}}
                                <div x-show="reupload" x-transition>
                                    <div class="flex justify-between items-center mb-4">
                                        <h3 class="text-lg font-semibold">آپلود تصاویر چک (حداکثر ۱۶ فایل) *</h3>
                                        <button type="button" @click="addCheque" class="px-3 py-1 bg-blue-500 text-white rounded-md text-sm hover:bg-blue-600">
                                            + افزودن فایل
                                        </button>
                                    </div>
                                    <p class="text-sm text-gray-600 mb-4">حداقل ۱ فایل الزامی است. (فرمت: jpg, png, pdf - حداکثر ۱ مگابایت)</p>

                                    <div class="space-y-4">
                                        <template x-for="(cheque, index) in cheques" :key="cheque.id">
                                            <div class="p-4 border rounded-lg flex items-center gap-4 relative">
                                                <span x-text="index + 1" class="text-gray-500"></span>
                                                <input :id="'cheque_' + cheque.id" name="cheques[]" type="file" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100" 
                                                       {{-- اگر فایل‌ها از قبل بودند، این فیلد دیگر required نیست --}}
                                                       {{ empty($cheque_documents) ? 'required' : '' }}>
                                                
                                                <button type="button" @click="removeCheque(index)" x-show="cheques.length > 1"
                                                        class="absolute top-2 left-2 text-red-500 hover:text-red-700" style="left: 0.5rem; top: 0.5rem;">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" /></svg>
                                                </button>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                                {{-- ✅ END: فرم آپلود --}}

                                {{-- ۳. دکمه ارسال --}}
                                <div class="mt-8">
                                    <x-primary-button class="w-full justify-center text-lg py-3 bg-orange-500 hover:bg-orange-400">
                                        <span x-show="reupload">آپلود مدارک و (در صورت تمایل) پرداخت نقدی</span>
                                        <span x-show="!reupload">فقط پرداخت نقدی (مدارک قبلا آپلود شده)</span>
                                    </x-primary-button>
                                </div>
                            </form>
                        </div>

                    @else

                        {{-- ********* حالت طرح اقساطی (اعتباری) (کد بدون تغییر) ********* --}}
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            {{-- ۱. پرداخت نقدی (اختیاری) --}}
                            <div class="p-6 border rounded-lg">
                                <h3 class="text-lg font-bold mb-4">۱. پرداخت نقدی (اختیاری)</h3>
                                <p class="text-sm text-gray-600 mb-4">مبلغ را به <b>ریال</b> وارد کنید.</p>
                                
                                <form action="{{ route('payment.cash.redirect', $invoice->id) }}" method="POST">
                                    @csrf
                                    <div>
                                        <x-input-label for="partial_amount" value="مبلغ پرداخت نقدی (ریال)" />
                                        <x-text-input id="partial_amount" name="partial_amount" type="number" class="mt-1 block w-full" 
                                                      min="0" max="{{ $remainingAmountRial }}" :value="old('partial_amount', 0)" />
                                    </div>
                                    <div class="mt-4">
                                        <x-primary-button class="w-full justify-center bg-orange-500 hover:bg-orange-400">
                                            پرداخت نقدی (سامان)
                                        </x->
                                    </div>
                                </form>
                            </div>

                            {{-- ۲. پرداخت اعتباری (نهایی) --}}
                            <div class="p-6 border rounded-lg bg-gray-50">
                                <h3 class="text-lg font-bold mb-4">۲. پرداخت اعتباری (نهایی)</h3>
                                <p class="text-sm text-gray-600 mb-4">مبلغ باقیمانده به صورت اعتباری پرداخت خواهد شد.</p>
                                
                                <form action="{{ route('payment.redirect', $invoice->id) }}" method="POST">
                                    @csrf
                                    <div class="text-center">
                                        <div class="text-gray-600">مبلغ قابل پرداخت اعتباری (ریال):</div>
                                        <div class="text-3xl font-bold my-4">{{ number_format($remainingAmountRial) }}</div>
                                        
                                        @if($remainingAmountRial > 0)
                                            <x-primary-button class="w-full justify-center text-lg px-8 py-3">
                                                پرداخت اعتباری (باجت)
                                            </x-primary-button>
                                        @else
                                            <span class="w-full block text-center px-4 py-2 bg-gray-400 border rounded-md font-semibold text-xs text-white uppercase">
                                                تسویه شده
                                            </span>
                                        @endif
                                    </div>
                                </form>
                            </div>
                        </div>

                    @endif
                    {{-- ✅✅✅ END: بخش پرداخت ✅✅✅ --}}

                </div>
            </div>
        </div>
    </div>
</x-app-layout>