<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{-- ✅ عنوان تفکیک شده بر اساس نقش --}}
                @if(auth()->user()->role === 'regional_manager')
                    لیست پیش فاکتورهای نمایندگان
                @else
                    گزارش جامع پیش فاکتورها (ادمین/حسابدار)
                @endif
            </h2>
            
            {{-- دکمه‌های افزودن (فقط ادمین کل) --}}
            @if(auth()->user()->role == 'super_admin')
                <div class="flex space-x-2 space-x-reverse">
                    {{-- ============================================= --}}
                    {{-- ## START: ✅✅✅ اصلاح روت‌ها ✅✅✅ ## --}}
                    {{-- ============================================= --}}
                    <a href="{{ route('admin.products.import.form') }}" class="inline-flex items-center px-4 py-2 bg-green-600 border rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-700">
                        درون‌ریزی
                    </a>
                    <a href="{{ route('admin.products.create') }}" class="inline-flex items-center px-4 py-2 bg-gray-800 border rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700">
                        افزودن محصول
                    </a>
                    {{-- ============================================= --}}
                    {{-- ## END: اصلاح روت‌ها ## --}}
                    {{-- ============================================= --}}
                </div>
            @endif
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    
                    {{-- فرم جستجو و فیلتر --}}
                    <form method="GET" action="{{ url()->current() }}" class="mb-6">
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                            <x-text-input type="text" name="search" placeholder="جستجو (شماره، مشتری، نماینده)..." value="{{ request('search') }}" />
                            <select name="status" class="border-gray-300 rounded-md shadow-sm">
                                <option value="all">همه وضعیت‌ها</option>
                                <option value="pending" @selected(request('status') == 'pending')>در انتظار پرداخت</option>
                                <option value="processing" @selected(request('status') == 'processing')>در حال بررسی</option>
                                <option value="shipped" @selected(request('status') == 'shipped')>ارسال شده</option>
                                <option value="delivered" @selected(request('status') == 'delivered')>تحویل داده شده</option>
                                <option value="rejected" @selected(request('status') == 'rejected')>لغو شده</option>
                            </select>
                            <x-primary-button type="submit">فیلتر</x-primary-button>
                        </div>
                    </form>

                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">شماره</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">مشتری</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">نماینده</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">مبلغ (ریال)</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">تعداد اقلام</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">وضعیت</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"></th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($invoices as $invoice)
                                    <tr>
                                        <td class="px-6 py-4 text-sm">#{{ $invoice->id }}</td>
                                        <td class="px-6 py-4 text-sm">{{ $invoice->customer->name ?? 'حذف شده' }}</td>
                                        <td class="px-6 py-4 text-sm">{{ $invoice->user->name ?? 'حذف شده' }}</td>
                                        <td class="px-6 py-4 text-sm font-bold">{{ number_format($invoice->final_price) }}</td>
                                        <td class="px-6 py-4 text-sm text-center">{{ $invoice->products_count }}</td>
                                        <td class="px-6 py-4 text-sm">
                                            <span class="px-2 py-0.5 rounded-full text-xs font-medium {{ match($invoice->status) {
                                                'pending' => 'bg-yellow-100 text-yellow-800',
                                                'processing' => 'bg-blue-100 text-blue-800',
                                                'shipped' => 'bg-indigo-100 text-indigo-800',
                                                'delivered' => 'bg-green-100 text-green-800',
                                                'rejected' => 'bg-red-100 text-red-800',
                                                default => 'bg-gray-100 text-gray-800',
                                            } }}">
                                                {{ __($invoice->status) }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-left text-sm">
                                            {{-- ✅ تعیین روت مشاهده بر اساس نقش --}}
                                            @php
                                                // (بر اساس نقش فعلی کاربر، روت "مشاهده" را تعیین کن)
                                                $showRoute = match(auth()->user()->role) {
                                                    'super_admin' => route('admin.invoices.show', $invoice->id),
                                                    'accountant' => route('accountant.invoices.show', $invoice->id),
                                                    'regional_manager' => route('regional-manager.invoices.show', $invoice->id),
                                                    default => '#'
                                                };
                                            @endphp
                                            <a href="{{ $showRoute }}" class="text-indigo-600 hover:text-indigo-900">
                                                مشاهده
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="7" class="text-center py-4">هیچ پیش فاکتوری یافت نشد.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        {{ $invoices->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>