<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاکتور شماره {{ $invoice->id }}</title>
    <style>
        body {
            /* 💡 نکته: بهتر است فونت وزیرمتن را در فایل PDF خود embed کنید
               یا از فونتی استفاده کنید که سرور PDF از آن پشتیبانی می‌کند.
               استفاده از sans-serif به عنوان fallback امن است. */
            font-family: 'dejavu sans', sans-serif; 
            direction: rtl;
            text-align: right;
            background-color: #fff;
            color: #000;
        }
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
            font-size: 16px;
            line-height: 24px;
        }
        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: right;
            border-collapse: collapse;
        }
        .invoice-box table td {
            padding: 5px;
            vertical-align: top;
        }
        .invoice-box table tr.top table td {
            padding-bottom: 20px;
        }
        .invoice-box table tr.top table td.title {
            font-size: 45px;
            line-height: 45px;
            color: #333;
        }
        .invoice-box table tr.information table td {
            padding-bottom: 40px;
        }
        .invoice-box table tr.heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }
        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }
        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }
        .invoice-box table tr.item.last td {
            border-bottom: none;
        }
        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }
        .logo {
            max-width: 150px;
            max-height: 100px;
        }
    </style>
</head>
<body>
    <div class="invoice-box">
        <table>
            <tr class="top">
                <td colspan="4">
                    <table>
                        <tr>
                            <td class="title">
                                @if(isset($settings['company_logo']))
                                    {{-- 💡 توجه: public_path برای دسترسی مستقیم به فایل در زمان ساخت PDF استفاده می‌شود --}}
                                    <img src="{{ public_path('storage/' . $settings['company_logo']) }}" class="logo" alt="Company Logo">
                                @else
                                    {{ $settings['company_name'] ?? 'نام شرکت' }}
                                @endif
                            </td>
                            <td style="text-align: left; font-size: 14px;">
                                شماره فاکتور: {{ $invoice->id }}<br>
                                تاریخ صدور: {{ verta($invoice->created_at)->format('Y/m/d') }}
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="information">
                <td colspan="4">
                    <table>
                        <tr>
                            <td>
                                <strong>{{ $settings['company_name'] ?? 'نام شرکت' }}</strong><br>
                                {{ $settings['company_address'] ?? 'آدرس شرکت' }}<br>
                                {{ $settings['company_phone'] ?? 'شماره تماس شرکت' }}
                            </td>
                            
                            {{-- ============================================= --}}
                            {{-- START: بخش اصلاح شده اطلاعات مشتری             --}}
                            {{-- ============================================= --}}
                            <td style="text-align: left; font-size: 14px;">
                                <strong>صورتحساب برای:</strong><br>
                                {{ $invoice->customer->name }}<br>
                                کد ملی: {{ $invoice->customer->national_id ?? '-' }}<br>
                                موبایل: {{ $invoice->customer->mobile ?? '-' }}<br>
                                آدرس: {{ $invoice->customer->address ?? '-' }}
                            </td>
                            {{-- ============================================= --}}
                            {{-- END: بخش اصلاح شده                             --}}
                            {{-- ============================================= --}}
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="heading">
                <td>محصول</td>
                <td>طرح اقساط</td>
                <td style="text-align: left;">مبلغ نهایی</td>
            </tr>

            <tr class="item">
                <td>{{ $invoice->product->name }}</td>
                <td>{{ $invoice->planOption->plan->name }} ({{ $invoice->planOption->months }} ماهه)</td>
                <td style="text-align: left;">{{ number_format($invoice->final_price) }} ریال</td>
            </tr>

            <tr class="total">
                <td colspan="2"></td>
                <td style="text-align: left; font-weight: bold;">
                   جمع کل: {{ number_format($invoice->final_price) }} ریال
                </td>
            </tr>

            <tr>
                <td colspan="4" style="padding-top: 50px; font-size: 14px;">
                    <p><strong>نماینده فروش:</strong> {{ $invoice->user->name }}</p>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>