<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{-- (اگر متغیر $is_accountant وجود داشت یعنی پنل حسابدار است) --}}
                @if(isset($is_accountant) && $is_accountant)
                    جزئیات پیش فاکتور #{{ $invoice->id }} (حسابداری)
                @else
                    جزئیات پیش فاکتور #{{ $invoice->id }} (مدیر منطقه)
                @endif
            </h2>
            
            {{-- دکمه بازگشت --}}
            <a href="{{ url()->previous() }}" class="px-4 py-2 bg-gray-600 text-white rounded-lg text-sm hover:bg-gray-700">
                &larr; بازگشت به لیست
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 grid grid-cols-1 md:grid-cols-3 gap-6">

            @if (session('success'))
                <div class="md:col-span-3 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif
            @if (session('error'))
                <div class="md:col-span-3 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('error') }}</span>
                </div>
            @endif

            <div class="md:col-span-2 space-y-6">
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">اطلاعات مشتری و نماینده</h3>
                    <div class="grid grid-cols-2 gap-4 text-sm">
                        <p><strong>مشتری:</strong> {{ $invoice->customer->name }}</p>
                        <p><strong>کد ملی:</strong> {{ $invoice->customer->national_id }}</p>
                        <p><strong>موبایل:</strong> {{ $invoice->customer->mobile }}</p>
                        <p><strong>آدرس:</strong> {{ $invoice->customer->address }}</p>
                        <p class="col-span-2"><strong>نماینده:</strong> {{ $invoice->user->name }} ({{ $invoice->user->email }})</p>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">اطلاعات سبد خرید</h3>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 text-sm">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-2 text-right">محصول</th>
                                    <th class="px-4 py-2 text-center">تعداد</th>
                                    <th class="px-4 py-2 text-center">قیمت واحد (ریال)</th>
                                    <th class="px-4 py-2 text-center">جمع (ریال)</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @php $total_base_price = 0; @endphp
                                @foreach($invoice->products as $product)
                                @php 
                                    $item_total = $product->pivot->price * $product->pivot->quantity;
                                    $total_base_price += $item_total;
                                @endphp
                                <tr>
                                    <td class="px-4 py-2">{{ $product->name }} ({{ $product->code }})</td>
                                    <td class="px-4 py-2 text-center">{{ $product->pivot->quantity }}</td>
                                    <td class="px-4 py-2 text-center">{{ number_format($product->pivot->price) }}</td>
                                    <td class="px-4 py-2 text-center">{{ number_format($item_total) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                @if($documents && count($documents) > 0)
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">مدارک ارسالی نماینده</h3>
                    <ul class="list-disc list-inside space-y-2">
                        @foreach($documents as $doc_path)
                        <li>
                            <a href="{{ asset('storage/' . $doc_path) }}" target="_blank" class="text-indigo-600 hover:text-indigo-800">
                                مشاهده مدرک
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </div>
                @endif
                
                @if($cheque_documents && count($cheque_documents) > 0)
                <div class="bg-yellow-50 p-6 rounded-lg shadow-md border border-yellow-300">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2 border-yellow-200">مدارک چک ارسالی</h3>
                    <ul class="list-disc list-inside space-y-2">
                        @foreach($cheque_documents as $doc_path)
                        <li>
                            <a href="{{ asset('storage/' . $doc_path) }}" target="_blank" class="text-indigo-600 hover:text-indigo-800">
                                مشاهده فایل چک
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </div>
                @endif

            </div>

            <div class="md:col-span-1 space-y-6">
                
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">اطلاعات مالی</h3>
                    <div class="space-y-3 text-sm">
                        <p class="flex justify-between"><strong>طرح:</strong> <span>{{ $invoice->planOption->plan->name }} ({{ $invoice->planOption->months }} ماهه)</span></p>
                        <p class="flex justify-between"><strong>قیمت پایه:</strong> <span>{{ number_format($total_base_price) }} ریال</span></p>
                        <p class="flex justify-between"><strong>کارمزد:</strong> <span>{{ number_format($invoice->final_price - $total_base_price) }} ریال</span></p>
                        <p class="flex justify-between font-bold text-base"><strong>مبلغ نهایی:</strong> <span>{{ number_format($invoice->final_price) }} ریال</span></p>
                        <hr>
                        <p class="flex justify-between text-blue-600"><strong>پرداخت نقدی:</strong> <span>{{ number_format($invoice->paid_amount_cash) }} ریال</span></p>
                        <p class="flex justify-between font-bold text-base text-red-600"><strong>مانده:</strong> <span>{{ number_format($invoice->final_price - $invoice->paid_amount_cash) }} ریال</span></p>
                        <hr>
                        <p class="flex justify-between"><strong>وضعیت فعلی:</strong> 
                            <span class="px-2 py-1 rounded text-white text-xs
                                @if($invoice->status == 'pending') bg-yellow-500
                                @elseif($invoice->status == 'processing') bg-blue-500
                                @elseif($invoice->status == 'ready_to_ship') bg-cyan-500
                                @elseif($invoice->status == 'shipped') bg-indigo-500
                                @elseif($invoice->status == 'delivered') bg-green-500
                                @elseif($invoice->status == 'returned') bg-gray-500
                                @elseif($invoice->status == 'rejected') bg-red-500
                                @endif
                            ">
                                {{ __($invoice->status) }}
                            </span>
                        </p>
                        
                        <a href="{{ isset($is_accountant) ? route('accountant.invoices.print', $invoice) : route('regional-manager.invoices.print', $invoice) }}" target="_blank" class="block w-full text-center mt-4">
                            <x-secondary-button class="w-full justify-center">
                            پیش فاکتور 
                            </x-secondary-button>
                        </a>
                    </div>
                </div>

                {{-- ✅✅✅ START: افزودن شرط برای مخفی کردن فرم از مدیر منطقه ✅✅✅ --}}
                {{-- 
                    این فرم فقط زمانی نمایش داده می‌شود که:
                    1. کاربر از پنل حسابداری آمده باشد (is_accountant == true)
                    2. یا کاربر وارد شده، مدیر کل باشد (super_admin)
                --}}
                @if( (isset($is_accountant) && $is_accountant) || auth()->user()->role === 'super_admin' )
                
                {{-- بخش تغییر وضعیت --}}
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">تغییر وضعیت پیش فاکتور</h3>
                    
                    {{-- 
                        مسیر فرم داینامیک است:
                        - اگر حسابدار بود -> accountant.invoices.updateStatus
                        - اگر مدیر کل بود -> admin.invoices.updateStatus (که در روت‌ها به همان کنترلر حسابدار اشاره دارد)
                    --}}
                    <form action="{{ isset($is_accountant) ? route('accountant.invoices.updateStatus', $invoice) : route('admin.invoices.updateStatus', $invoice) }}" method="POST">
                        @csrf
                        <div class="space-y-4">
                            <div>
                                <x-input-label for="status" value="تغییر وضعیت به:" />
                                <select name="status" id="status" class="block mt-1 w-full border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 rounded-md shadow-sm">
                                    <option value="pending" {{ $invoice->status == 'pending' ? 'selected' : '' }}>{{ __('pending') }} (در انتظار پرداخت)</option>
                                    <option value="processing" {{ $invoice->status == 'processing' ? 'selected' : '' }}>{{ __('processing') }} (در حال انجام)</option>
                                    <option value="ready_to_ship" {{ $invoice->status == 'ready_to_ship' ? 'selected' : '' }}>{{ __('ready_to_ship') }} (آماده ارسال)</option>
                                    <option value="shipped" {{ $invoice->status == 'shipped' ? 'selected' : '' }}>{{ __('shipped') }} (ارسال شده)</option>
                                    <option value="delivered" {{ $invoice->status == 'delivered' ? 'selected' : '' }}>{{ __('delivered') }} (تحویل شده)</option>
                                    <option value="returned" {{ $invoice->status == 'returned' ? 'selected' : '' }}>{{ __('returned') }} (مرجوع شده)</option>
                                    <option value="rejected" {{ $invoice->status == 'rejected' ? 'selected' : '' }}>{{ __('rejected') }} (لغو شده)</option>
                                </select>
                            </div>
                            <div>
                                <x-primary-button class="w-full justify-center">
                                    ثبت تغییر وضعیت
                                </x-primary-button>
                            </div>
                        </div>
                    </form>
                </div>
                
                {{-- ✅✅✅ END: پایان شرط ✅✅✅ --}}
                @endif

            </div>

        </div>
    </div>
</x-app-layout>