<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold leading-tight text-gray-800">
            جزئیات محصول: {{ $product->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="mx-auto max-w-7xl sm:px-6 lg:px-8">
            <div class="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200 md:flex md:space-x-8 md:space-x-reverse">

                    <div class="md:w-1/3">
                        <img src="{{ $product->image_path ? asset('storage/' . $product->image_path) : 'https://via.placeholder.com/400?text=No+Image' }}"
                             alt="{{ $product->name }}"
                             class="object-cover w-full h-auto rounded-lg shadow-md">
                    </div>

                    <div class="mt-6 md:w-2/3 md:mt-0">
                        <h1 class="text-3xl font-bold text-gray-900">{{ $product->name }}</h1>
                        
                        <p class="mt-2 text-lg text-gray-700">
                            <span class="font-semibold">کد محصول:</span> {{ $product->code }}
                        </p>
                        
                        @if($product->category)
                        <p class="mt-2 text-lg text-gray-700">
                            <span class="font-semibold">دسته‌بندی:</span> {{ $product->category->name }}
                        </p>
                        @endif

                        <div class="mt-4">
                            @if($product->discount_price > 0 && $product->discount_price < $product->price)
                                <span class="text-3xl font-bold text-red-600">{{ number_format($product->getActivePriceAttribute()) }} ریال</span>
                                <span class="ml-2 text-xl text-gray-500 line-through">{{ number_format($product->price) }} ریال</span>
                            @else
                                <span class="text-3xl font-bold text-gray-800">{{ number_format($product->price) }} ریال</span>
                            @endif
                        </div>
                        
                        <p class="mt-4 text-lg {{ $product->stock > 0 ? 'text-green-600' : 'text-red-600' }}">
                            @if($product->stock > 0)
                                <span class="font-semibold">موجود در انبار</span> ({{ $product->stock }} عدد)
                            @else
                                <span class="font-semibold">ناموجود</span>
                            @endif
                        </p>
                        
                        @if(!empty($product->features))
                            <div class="mt-8">
                                <h3 class="text-xl font-semibold text-gray-800 border-b-2 border-gray-200 pb-2">
                                    مشخصات و ویژگی‌ها
                                </h3>
                                <ul class="mt-4 space-y-3">
                                    {{-- 
                                        ما فرض می‌کنیم که features به صورت آرایه‌ای از آبجکت‌ها ذخیره شده
                                        [{"key": "سیستم عامل", "value": "اندروید"}, ...]
                                    --}}
                                    @foreach($product->features as $feature)
                                        @if(is_array($feature) && !empty($feature['key']) && !empty($feature['value']))
                                        <li class="flex text-base">
                                            <span class="w-1/3 font-medium text-gray-700 rtl:pl-4 ltr:pr-4">{{ $feature['key'] }}:</span>
                                            <span class="w-2/3 text-gray-800">{{ $feature['value'] }}</span>
                                        </li>
                                        @endif
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="mt-8">
                            {{-- بازگشت به صفحه قبلی (لیست محصولات سبد خرید) --}}
                            <a href="{{ url()->previous() }}" class="inline-block px-6 py-2 text-white bg-gray-600 rounded-lg hover:bg-gray-700">
                                &rarr; بازگشت
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>