<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\InvoiceController as ApiInvoiceController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// روت‌های محافظت شده با Sanctum (نیاز به توکن API)
Route::middleware('auth:sanctum')->group(function () {
    
    // خروجی لیست پیش فاکتورها (با فیلتر وضعیت)
    // e.g., /api/v1/invoices?status=processing
    Route::get('/v1/invoices', [ApiInvoiceController::class, 'index']);
    
    // خروجی یک پیش فاکتور خاص
    Route::get('/v1/invoices/{invoice}', [ApiInvoiceController::class, 'show']);

    // (مثال: روت دریافت اطلاعات کاربر احراز هویت شده)
    Route::get('/v1/user', function (Request $request) {
        return $request->user();
    });
});