<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;

// کنترلرهای ادمین
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\Admin\PlanController as AdminPlanController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\InventoryController;
use App\Http\Controllers\Admin\BundleController;

// کنترلرهای نماینده
use App\Http\Controllers\Agent\CustomerController;
use App\Http\Controllers\Agent\InvoiceController as AgentInvoiceController;

// کنترلر پرداخت
use App\Http\Controllers\PaymentController;

// کنترلرهای مدیر منطقه
use App\Http\Controllers\RegionalManager\ApprovalController;
use App\Http\Controllers\Shared\ProductController;
// کنترلرهای حسابدار
use App\Http\Controllers\Accountant\InvoiceController as AccountantInvoiceController;

// کنترلر اشتراکی
use App\Http\Controllers\Shared\ProductController as SharedProductController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // مسیرهای پرداخت (مشترک برای نماینده)
    Route::get('payment/start/{invoice}', [PaymentController::class, 'start'])->name('payment.start');
    Route::post('payment/gateway/redirect/{invoice}', [PaymentController::class, 'redirectToGateway'])->name('payment.gateway.redirect');
    Route::get('payment/gateway/callback', [PaymentController::class, 'handleCallback'])->name('payment.callback');
    Route::post('payment/cash/redirect/{invoice}', [PaymentController::class, 'redirectToCashGateway'])->name('payment.cash.redirect');
    Route::get('payment/cash/callback', [PaymentController::class, 'handleCashCallback'])->name('payment.cash.callback');
});

// ===================================
// 1. Super Admin Routes
// ===================================
Route::middleware(['auth', 'is.super-admin'])->prefix('admin')->name('admin.')->group(function () {
    // Users
    Route::resource('users', UserController::class)->except(['show']);
    Route::get('users/import', [UserController::class, 'showImportForm'])->name('users.import.show');
    Route::post('users/import', [UserController::class, 'import'])->name('users.import.store');
    // ✅✅✅ این دو خط را اضافه کنید ✅✅✅
    Route::get('/users/import', [UserController::class, 'showImportForm'])->name('users.import.form');
    Route::post('/users/import', [UserController::class, 'import'])->name('users.import.submit');
    // ✅✅✅ پایان بخش اضافه شده ✅✅✅
    // Products
    // ✅✅✅ خطای ناهماهنگی نام روت در این خط اصلاح شد ✅✅✅
    Route::get('products/import', [AdminProductController::class, 'showImportForm'])->name('products.import.form'); // قبلا 'products.import.show' بود
    Route::post('products/import', [AdminProductController::class, 'import'])->name('products.import.store');
    Route::resource('products', AdminProductController::class)->except(['show']);
    
    // Categories
    Route::resource('categories', CategoryController::class)->except(['show']);
    // Bundles
    Route::resource('bundles', BundleController::class)->except(['show']);
    // Inventory
    Route::get('inventory', [InventoryController::class, 'index'])->name('inventory.index');
    Route::post('inventory/{product}/stock', [InventoryController::class, 'updateStock'])->name('inventory.stock.update');

    // Plans
    Route::resource('plans', AdminPlanController::class)->except(['show']);
    Route::post('plans/{plan}/options', [AdminPlanController::class, 'storeOption'])->name('plans.options.store');
    Route::delete('plans/options/{option}', [AdminPlanController::class, 'destroyOption'])->name('plans.options.destroy');

    // Settings
    Route::get('settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('settings', [SettingController::class, 'store'])->name('settings.store');
    
    // Reports
    Route::get('reports', [ReportController::class, 'index'])->name('reports.index');
    Route::get('reports/all-agents', [ReportController::class, 'allAgents'])->name('reports.allAgents');
    Route::get('reports/agent/{user}', [ReportController::class, 'showAgent'])->name('reports.showAgent');
    Route::get('reports/top-products', [ReportController::class, 'topProducts'])->name('reports.topProducts');
    Route::get('reports/dead-stock', [ReportController::class, 'deadStock'])->name('reports.deadStock');
    Route::get('reports/by-category', [ReportController::class, 'byCategory'])->name('reports.byCategory');
    Route::get('reports/plan-options', [ReportController::class, 'planOptions'])->name('reports.planOptions');

    // Toggle Agent Status (Super Admin & Accountant)
    Route::post('users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggleStatus');
    
    // Invoices (Super Admin)
    Route::get('invoices', [AccountantInvoiceController::class, 'index'])->name('invoices.index');
    Route::get('invoices/{invoice}', [AccountantInvoiceController::class, 'show'])->name('invoices.show');
    Route::post('invoices/{invoice}/status', [AccountantInvoiceController::class, 'updateStatus'])->name('invoices.updateStatus');
    Route::get('invoices/{invoice}/print', [AccountantInvoiceController::class, 'printInvoice'])->name('invoices.print');

});

// ===================================
// 2. Agent Routes
// ===================================
Route::middleware(['auth', 'is.agent'])->prefix('agent')->name('agent.')->group(function () {
    Route::resource('customers', CustomerController::class)->except(['show']);
    
    // Invoice Creation Flow
    Route::prefix('cart')->group(function () {
        Route::get('plans', [AgentInvoiceController::class, 'listPlans'])->name('plans.list');
        Route::get('plans/{plan}/options', [AgentInvoiceController::class, 'listPlanOptions'])->name('plans.options');
        Route::get('start/{option}', [AgentInvoiceController::class, 'startCart'])->name('cart.start');
        Route::get('products', [AgentInvoiceController::class, 'showProductList'])->name('cart.products');
        Route::get('review', [AgentInvoiceController::class, 'showCart'])->name('cart.review');
        Route::post('store', [AgentInvoiceController::class, 'storeInvoice'])->name('cart.store');
        // (Add/Remove items)
        Route::post('add', [AgentInvoiceController::class, 'cartAdd'])->name('cart.add');
        Route::post('remove', [AgentInvoiceController::class, 'cartRemove'])->name('cart.remove');
    });
    
    // Invoice Management
    Route::get('invoices', [AgentInvoiceController::class, 'index'])->name('invoices.index');
    Route::get('invoices/{invoice}/print', [AgentInvoiceController::class, 'printInvoice'])->name('invoices.print');
    
    //  مسیر جدید برای جزئیات محصول (نماینده)
    Route::get('products/{product}', [SharedProductController::class, 'show'])->name('products.show');
});

// ===================================
// 3. Regional Manager Routes
// ===================================
Route::middleware(['auth', 'is.regional-manager'])->prefix('regional-manager')->name('regional-manager.')->group(function () {
    // Invoice Approval
    Route::get('invoices', [ApprovalController::class, 'index'])->name('invoices.index');
    Route::get('invoices/{invoice}', [ApprovalController::class, 'show'])->name('invoices.show');
    Route::post('invoices/{invoice}/status', [ApprovalController::class, 'updateStatus'])->name('invoices.updateStatus');
    Route::get('invoices/{invoice}/print', [ApprovalController::class, 'printInvoice'])->name('invoices.print');
    // مدیریت کاربران زیرمجموعه
    Route::get('users', [UserController::class, 'index'])->name('users.index');
    Route::get('users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('users', [UserController::class, 'store'])->name('users.store');
    Route::get('/products', [ProductController::class, 'index'])->name('products.index');
    //  مسیر جدید برای جزئیات محصول (مدیر منطقه)
    Route::get('products/{product}', [SharedProductController::class, 'show'])->name('products.show');
});

// ===================================
// 4. Accountant Routes
// ===================================
Route::middleware(['auth', 'is.accountant'])->prefix('accountant')->name('accountant.')->group(function () {
    Route::get('invoices', [AccountantInvoiceController::class, 'index'])->name('invoices.index');
    Route::get('invoices/{invoice}', [AccountantInvoiceController::class, 'show'])->name('invoices.show');
    Route::post('invoices/{invoice}/status', [AccountantInvoiceController::class, 'updateStatus'])->name('invoices.updateStatus');
    Route::get('invoices/{invoice}/print', [AccountantInvoiceController::class, 'printInvoice'])->name('invoices.print');

    // Toggle Agent Status (Accountant)
    Route::post('users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggleStatus');
});

require __DIR__.'/auth.php';