<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            <?php echo e(__('Dashboard')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            <?php if(!empty($data)): ?>
                
                
                <div class="mb-6 bg-white p-4 shadow-sm sm:rounded-lg" 
                     x-data="dashboardAgentFilter({
                        selectedAgent: '<?php echo e(request('agent_id', 'all')); ?>',
                        agents: <?php echo e(json_encode($data['agents_list'] ?? [])); ?>,
                        urls: {
                            dashboard: '<?php echo e(route('dashboard')); ?>',
                            toggleStatusBase: '/admin/users'
                        },
                        csrf: '<?php echo e(csrf_token()); ?>'
                     })">
                    
                    <div class="flex items-center space-x-4 space-x-reverse">
                        <label for="agent_filter" class="font-medium text-gray-700">فیلتر گزارش بر اساس نماینده:</label>
                        <select id="agent_filter" x-model="selectedAgent" @change="changeAgent" class="border-gray-300 rounded-md shadow-sm w-1/3">
                            <option value="all">-- نمایش آمار کل --</option>
                            <template x-for="agent in agents" :key="agent.id">
                                <option :value="agent.id" x-text="agent.name + (agent.status === 'active' ? ' (فعال)' : ' (غیرفعال)')"></option>
                            </template>
                        </select>
                        <template x-if="selectedAgent !== 'all' && agents.find(a => a.id == selectedAgent)">
                            <button @click.prevent="toggleStatus(selectedAgent, agents.find(a => a.id == selectedAgent).name)"
                                    :class="{
                                        'bg-red-500 hover:bg-red-600': agents.find(a => a.id == selectedAgent)?.status === 'active',
                                        'bg-green-500 hover:bg-green-600': agents.find(a => a.id == selectedAgent)?.status === 'inactive'
                                    }"
                                    class="px-3 py-2 text-white text-xs rounded-md">
                                <span x-text="agents.find(a => a.id == selectedAgent)?.status === 'active' ? 'غیرفعال کردن' : 'فعال کردن'"></span>
                            </button>
                        </template>
                    </div>
                    <?php if(!empty($data['selected_agent'])): ?>
                        <div class="mt-2 text-sm text-gray-500">
                            * در حال مشاهده گزارش‌های مربوط به: <span class="font-bold"><?php echo e($data['selected_agent']->name); ?></span>
                        </div>
                    <?php endif; ?>
                </div>


                
                <h3 class="text-xl font-bold text-gray-800 mb-4">آمار وضعیت‌های خاص</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-3 gap-6 mb-8">
                    
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-yellow-400">
                        <h4 class="text-gray-600 font-medium">در انتظار پرداخت</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2"><?php echo e($data['stats']['pending']['count']); ?> <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-yellow-600 mt-1"><?php echo e(number_format($data['stats']['pending']['amount'])); ?> <span class="text-xs">ریال</span></p>
                    </div>
                    
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-blue-400">
                        <h4 class="text-gray-600 font-medium">در حال انجام</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2"><?php echo e($data['stats']['processing']['count']); ?> <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-blue-600 mt-1"><?php echo e(number_format($data['stats']['processing']['amount'])); ?> <span class="text-xs">ریال</span></p>
                    </div>
                    
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-cyan-400">
                        <h4 class="text-gray-600 font-medium">آماده برای ارسال</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2"><?php echo e($data['stats']['ready_to_ship']['count']); ?> <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-cyan-600 mt-1"><?php echo e(number_format($data['stats']['ready_to_ship']['amount'])); ?> <span class="text-xs">ریال</span></p>
                    </div>
                    
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-indigo-400">
                        <h4 class="text-gray-600 font-medium">ارسال شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2"><?php echo e($data['stats']['shipped']['count']); ?> <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-indigo-600 mt-1"><?php echo e(number_format($data['stats']['shipped']['amount'])); ?> <span class="text-xs">ریال</span></p>
                    </div>
                    
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-green-400">
                        <h4 class="text-gray-600 font-medium">تحویل داده شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2"><?php echo e($data['stats']['delivered']['count']); ?> <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-green-600 mt-1"><?php echo e(number_format($data['stats']['delivered']['amount'])); ?> <span class="text-xs">ریال</span></p>
                    </div>
                    
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-orange-400">
                        <h4 class="text-gray-600 font-medium">مرجوع شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2"><?php echo e($data['stats']['returned']['count']); ?> <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-orange-600 mt-1"><?php echo e(number_format($data['stats']['returned']['amount'])); ?> <span class="text-xs">ریال</span></p>
                    </div>
                    
                    <div class="bg-white p-6 rounded-lg shadow-lg border-r-4 border-red-400">
                        <h4 class="text-gray-600 font-medium">لغو شده</h4>
                        <p class="text-2xl font-bold text-gray-900 mt-2"><?php echo e($data['stats']['rejected']['count']); ?> <span class="text-sm">سفارش</span></p>
                        <p class="text-lg font-semibold text-red-600 mt-1"><?php echo e(number_format($data['stats']['rejected']['amount'])); ?> <span class="text-xs">ریال</span></p>
                    </div>
                </div>
                

                
                <h3 class="text-xl font-bold text-gray-800 mb-4">نمودارهای عمومی</h3>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                    <div class="bg-white p-6 rounded-lg shadow-lg">
                        <h4 class="text-gray-800 font-bold mb-4">فروش ۳ ماه گذشته (شمسی)</h4>
                        <canvas id="monthSalesChart"></canvas>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-lg">
                        <h4 class="text-gray-800 font-bold mb-4">وضعیت سفارش‌ها (پرداخت شده)</h4>
                        <canvas id="statusPieChart" class="max-h-80 mx-auto"></canvas>
                    </div>
                </div>

                
                <?php if(isset($data['products_chart_labels'])): ?>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">گزارش‌های نماینده: <?php echo e($data['selected_agent']->name); ?></h3>
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                        <div class="bg-white p-6 rounded-lg shadow-lg">
                            <h4 class="text-gray-800 font-bold mb-4">۱۰ محصول پرفروش (تعداد)</h4>
                            <canvas id="productsChart"></canvas>
                        </div>
                        <div class="bg-white p-6 rounded-lg shadow-lg">
                            <h4 class="text-gray-800 font-bold mb-4">فروش بر اساس دسته‌بندی (تعداد)</h4>
                            <canvas id="categoriesChart" class="max-h-80 mx-auto"></canvas>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if(auth()->user()->role === 'super_admin' && !empty($data['agent_rankings'])): ?>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">رتبه‌بندی نمایندگان (۵ برتر)</h3>
                    <div class="bg-white overflow-hidden shadow-lg sm:rounded-lg p-6">
                        <ul class="space-y-3">
                            <?php $__empty_1 = true; $__currentLoopData = $data['agent_rankings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li class="flex justify-between items-center text-sm border-b pb-2">
                                    <span class="text-gray-700"><?php echo e($agent->user->name ?? 'نماینده حذف شده'); ?></span>
                                    <span class="font-semibold text-green-600"><?php echo e(number_format($agent->total_sales)); ?> ریال</span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <li class="text-gray-500">اطلاعاتی برای نمایش وجود ندارد.</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                <?php endif; ?>

            <?php else: ?>
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        به پنل خود خوش آمدید!
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <?php if(!empty($data)): ?>
        <script>
            // ✅ START: نمودار فروش ماهانه (اصلاح شده)
            const monthCtx = document.getElementById('monthSalesChart');
            new Chart(monthCtx, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($data['month_chart_labels'], 15, 512) ?>,
                    datasets: [{
                        label: 'مبلغ فروش (ریال)',
                        data: <?php echo json_encode($data['month_chart_data'], 15, 512) ?>,
                        // ✅ رنگ‌های درخواستی شما (قرمز، آبی، سبز)
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.5)', // قرمز (ماه اول)
                            'rgba(54, 162, 235, 0.5)', // آبی (ماه دوم)
                            'rgba(75, 192, 192, 0.5)', // سبز (ماه جاری)
                        ],
                        borderColor: [
                            'rgba(255, 99, 132, 1)',
                            'rgba(54, 162, 235, 1)',
                            'rgba(75, 192, 192, 1)',
                        ],
                        borderWidth: 1
                    }]
                },
                options: { 
                    scales: { y: { beginAtZero: true } },
                    plugins: {
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    let label = context.dataset.label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    if (context.parsed.y !== null) {
                                        label += new Intl.NumberFormat('fa-IR').format(context.parsed.y) + ' ریال';
                                    }
                                    return label;
                                }
                            }
                        }
                    }
                }
            });
            // ✅ END: نمودار فروش ماهانه

            // ✅ START: نمودار دایره‌ای (اصلاح شده)
            const pieCtx = document.getElementById('statusPieChart');
            new Chart(pieCtx, {
                type: 'pie',
                data: {
                    labels: <?php echo json_encode($data['status_chart_labels'], 15, 512) ?>, // این لیبل‌ها از کنترلر می‌آیند
                    datasets: [{
                        label: 'تعداد سفارش‌ها',
                        data: <?php echo json_encode($data['status_chart_data'], 15, 512) ?>,
                        backgroundColor: [
                            'rgba(54, 162, 235, 0.5)',  // processing (آبی)
                            'rgba(153, 102, 255, 0.5)', // ready_to_ship (بنفش)
                            'rgba(75, 192, 192, 0.5)',  // shipped (سبزآبی)
                            'rgba(255, 206, 86, 0.5)', // delivered (زرد)
                            'rgba(255, 159, 64, 0.5)', // returned (نارنجی)
                        ],
                    }]
                }
            });
            // ✅ END: نمودار دایره‌ای

            // ... (اسکریپت‌های نمودارهای نماینده و Alpine.js فیلتر - بدون تغییر) ...
            <?php if(isset($data['products_chart_labels'])): ?>
                const productsCtx = document.getElementById('productsChart');
                new Chart(productsCtx, {
                    type: 'bar',
                    data: {
                        labels: <?php echo json_encode($data['products_chart_labels'], 15, 512) ?>,
                        datasets: [{
                            label: 'تعداد فروش',
                            data: <?php echo json_encode($data['products_chart_data'], 15, 512) ?>,
                            backgroundColor: 'rgba(255, 99, 132, 0.5)',
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 1
                        }]
                    },
                    options: { 
                        scales: { y: { beginAtZero: true } },
                        indexAxis: 'y', 
                    }
                });
                const categoriesCtx = document.getElementById('categoriesChart');
                new Chart(categoriesCtx, {
                    type: 'doughnut',
                    data: {
                        labels: <?php echo json_encode($data['categories_chart_labels'], 15, 512) ?>,
                        datasets: [{
                            label: 'تعداد فروش',
                            data: <?php echo json_encode($data['categories_chart_data'], 15, 512) ?>,
                            backgroundColor: [
                                'rgba(255, 159, 64, 0.5)',
                                'rgba(75, 192, 192, 0.5)',
                                'rgba(153, 102, 255, 0.5)',
                                'rgba(255, 206, 86, 0.5)',
                            ],
                        }]
                    }
                });
            <?php endif; ?>
            function dashboardAgentFilter(data) {
                return {
                    selectedAgent: data.selectedAgent,
                    agents: data.agents,
                    changeAgent() {
                        if (this.selectedAgent === 'all') {
                            window.location.href = data.urls.dashboard;
                        } else {
                            window.location.href = data.urls.dashboard + '?agent_id=' + this.selectedAgent;
                        }
                    },
                    toggleStatus(agentId, agentName) {
                        if (!confirm(`آیا از تغییر وضعیت نماینده "${agentName}" مطمئن هستید؟`)) return;
                        let agent = this.agents.find(a => a.id == agentId);
                        fetch(`${data.urls.toggleStatusBase}/${agentId}/toggle-status`, {
                            method: 'PATCH',
                            headers: {
                                'X-CSRF-TOKEN': data.csrf,
                                'Accept': 'application/json'
                            }
                        })
                        .then(res => res.json())
                        .then(resData => { 
                            if (resData.success) { 
                                alert(resData.message); 
                                if (agent) agent.status = resData.new_status; 
                            } else { 
                                alert(resData.error || 'خطایی رخ داد.'); 
                            } 
                        })
                        .catch(err => alert('خطای ارتباطی.')); 
                    } 
                };
            }
        </script>
    <?php endif; ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\laragon\www\installment-app\resources\views/dashboard.blade.php ENDPATH**/ ?>