<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css">
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <style>
        body { font-family: 'Vazirmatn', sans-serif; }
    </style>
</head>


<body class="antialiased">
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
        <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php if(isset($header)): ?>
            <header class="bg-white dark:bg-gray-800 shadow">
                <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                    <?php echo e($header); ?>

                </div>
            </header>
        <?php endif; ?>

        <main class="content-area">
            
            <?php if(session('success')): ?>
                <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 pt-4">
                    <div class="p-4 text-sm text-green-700 bg-green-100 rounded-lg" role="alert">
                        <?php echo e(session('success')); ?>

                    </div>
                </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 pt-4">
                    <div class="p-4 text-sm text-red-700 bg-red-100 rounded-lg" role="alert">
                        <?php echo e(session('error')); ?>

                    </div>
                </div>
            <?php endif; ?>

            <?php echo e($slot); ?>

        </main>
    </div>
</body>
</html><?php /**PATH D:\laragon\www\installment-app\resources\views/layouts/app.blade.php ENDPATH**/ ?>